% Custom script for assessing the amount of time adult zebrafish spend in
% left and right sides of a novel tank. The code accepts a variable
% 'Sourcecodefile1', which is the raw (x, y) coordinates over time from Viewpoint
% tracking software.
%
% Input: Source code file 1
% The input file is taken from Viewpoint software. After a trial, this is
% done through the export raw data. This returns a .txt file. Then,
% before using this script, we remove all empty columns (past the (x,y)
% coorindates returned.
%
% Import data with 'Numeric Matrix' output type
%
% Output variables:
% Parsed data returns a modified form of the original tracking with dropped
% frames corrected for.
% Main output variable that we need are min_left and min_right
%
% USAGE:
% typical usage is to import with the MATLAB Import function, and then hit
% "Run" in the MATLAB editor.
%
% Written by Jung-Hwa Choi, Halpern Lab, Dartmouth Medical School
% A part of Choi et al.,2021.'Specialized neurons in the right habenula mediate 
response to aversive olfactory cues'.
%
  %% Set range
  % Insert name of file here to rename it to 'Sourcecodefile1'
  x_range = [10,631]; % These values come from Viewpoint tracking. These are the pixel coordinate at the x-edges of the tank
  y_range = [208, 435]; % These values come from Viewpoint tracking. These are the pixel coordinate at the y-edges of the tank
  mid_point = round(mean(x_range));
  
    % Get number of trials
    numberOfTrials = length(find(Sourcecodefile1(:,4) == 71));

    % Make new variable of type cell to store parsed data into
    parsed_data = cell(numberOfTrials,1);
    %% Clean up data
    % get start and stop positions

    % Viewpoint codes the start of a trial as 71, the end of a trial as 72,
    % and dropped frames as 99. 
    start_positions = find(Sourcecodefile1(:,4)==71);
    stop_positions = find(Sourcecodefile1(:,4)==72);
    dropped_positons = find(Sourcecodefile1(:,4)==99);

    % replace start positons with position in frame after
    % The output from Viewpoint tracking places the x-coorindates in the
    % 6th column and the y-coorindates in the 7th column
    for i = 1:length(start_positions)
        Sourcecodefile1(start_positions(i),6) = Sourcecodefile1(start_positions(i)+1,6);
        Sourcecodefile1(start_positions(i),7) = Sourcecodefile1(start_positions(i)+1,7);
    end

    % replace stop positons with position in frame before
    for i = 1:length(stop_positions)
        Sourcecodefile1(stop_positions(i),6) = Sourcecodefile1(stop_positions(i)-1,6);
        Sourcecodefile1(stop_positions(i),7) = Sourcecodefile1(stop_positions(i)-1,7);
    end

    % replace dropped positons with position in frame before
    for i = 1:length(dropped_positons)   
        Sourcecodefile1(dropped_positons(i),6) = Sourcecodefile1(dropped_positons(i)-1,6);
        Sourcecodefile1(dropped_positons(i),7) = Sourcecodefile1(dropped_positons(i)-1,7);
    end

    %% Parse data
    for i = 1:numberOfTrials
        parsed_data{i} = Sourcecodefile1(start_positions(i):stop_positions(i),:);
    end  
    %%  Measuring duration
    min_Left = [];    min_Right = [];
    
    for i = 1:length(parsed_data)
        tmp = parsed_data{i};
         % Duration in Left
            min_Left_total = find(tmp(1:round(length(tmp(:,6))),6)<mid_point);
        % Duration in Right
            min_Right_total = find(tmp(1:round(length(tmp(:,6))),6)>mid_point);
            
        if isempty(min_Left_total) == 1, min_Left_total = 0; end
        if isempty(min_Right_total) == 1, min_Right_total = 0; end

        min_Left  = [ min_Left  ; length(min_Left_total)/60 ];
        min_Right = [min_Right ; length(min_Right_total)/60 ];
    end    